var ctx;

function drawPizza() {
	ctx = document.getElementById("pizzaCanvas").getContext("2d");

	ctx.save();
	ctx.translate(200, 200);

	drawCrust();
	drawSauce();
	drawCheese();
	drawToppings(16, drawMushroom);
	drawToppings(16, drawPepperoni);
	drawToppings(16, drawGreenPepper);

	ctx.restore();
}

function drawCrust() {
	var crustGradient = ctx.createRadialGradient(0, 0, 180, 0, 0, 200);

	crustGradient.addColorStop(0, "rgba(230, 192, 117, 1)");
	crustGradient.addColorStop(1, "rgba(208, 113, 65, 1)");

	ctx.fillStyle = crustGradient;
	ctx.beginPath();
	ctx.arc(0, 0, 200, 0, 2 * Math.PI, false);
	ctx.fill();
}

function drawSauce() {
	ctx.fillStyle = "rgba(200, 55, 62, 1)";
	ctx.beginPath();
	ctx.arc(0, 0, 180, 0, 2 * Math.PI, false);
	ctx.fill();
}

function drawCheese() {
	ctx.fillStyle = "rgba(251, 246, 242, 1)";
	ctx.beginPath();
	ctx.arc(0, 0, 170, 0, 2 * Math.PI, false);
	ctx.fill();
}

function drawToppings(n, drawTopping) {
	ctx.save();
	ctx.rotate(2 * Math.random() * Math.PI);

	for (var i = 0; i < n; i++) {
		ctx.save();
		ctx.translate(0, 70 * (Math.sqrt(Math.random()) + i % 2) + 10);
		drawTopping();
		ctx.restore();
		ctx.rotate(2 * Math.PI / n);
	}

	ctx.restore();
}

function drawPepperoni() {
	ctx.save();
	ctx.fillStyle = "rgba(162, 53, 58, 1)";
	ctx.beginPath();
	ctx.arc(0, 0, 20, 0, 2 * Math.PI, false);
	ctx.fill();

	ctx.scale(0.1, 0.1);
	drawToppings(16, drawFat);
	ctx.restore();
}

function drawFat() {
	ctx.fillStyle = "rgba(255, 255, 255, " + 0.5 * Math.random() + ")";
	ctx.beginPath();
	ctx.arc(0, 0, 10 + 10 * Math.random(), 0, 2 * Math.PI, false);
	ctx.fill();
}

function drawGreenPepper() {
	var r1 = 14 + 6 * Math.random();
	var r2 = 14 + 6 * Math.random();
	var length = 40 + 20 * Math.random();
	
	ctx.save();
	ctx.rotate(2 * Math.random() * Math.PI);
	ctx.lineWidth = 6;
	ctx.strokeStyle = "rgba(139, 195, 60, 1)";
	
	ctx.beginPath();
	ctx.arc(r1 -  length / 2, r1 / 2, r1, -Math.PI, -0.5 * Math.PI, false);
	ctx.arc(length / 2 - r2, r2 / 2, r2, -0.5 * Math.PI, 0, false);
	ctx.stroke();
	
	ctx.restore();
}

function drawMushroom() {
	var mushroomGradient;
	
	ctx.save();
	ctx.rotate(2 * Math.random() * Math.PI);
	ctx.translate(0, 10);
	
	ctx.fillStyle = "rgba(211, 169, 101, 1)";
	
	ctx.beginPath();
	ctx.arc(0, 0, 30, 1.25 * Math.PI, 1.75 * Math.PI, false);
	ctx.lineTo(20, -10);
	ctx.lineTo(8, -10);
	ctx.lineTo(10, 10);
	ctx.lineTo(-10, 10);
	ctx.lineTo(-8, -10);
	ctx.lineTo(-20, -10);
	ctx.closePath();
	ctx.fill();
	
	ctx.save();
	ctx.rotate(-0.25 * Math.PI);
	ctx.beginPath();
	ctx.arc(0, -20, 10, 0, 2 * Math.PI, false);
	ctx.fill();
	
	ctx.rotate(0.5 * Math.PI);
	ctx.beginPath();
	ctx.arc(0, -20, 10, 0, 2 * Math.PI, false);
	ctx.fill();
	ctx.restore();
	
	mushroomGradient = ctx.createRadialGradient(-10, -9, 3, -10, -11, 6);
	mushroomGradient.addColorStop(0, "rgba(107, 93, 67, 1)");
	mushroomGradient.addColorStop(1, "rgba(211, 169, 101, 1)");

	ctx.fillStyle = mushroomGradient;
	ctx.beginPath();
	ctx.arc(-10, -11, 6, 0.4 * Math.PI, 1.65 * Math.PI, false);
	ctx.fill();

	mushroomGradient = ctx.createRadialGradient(10, -9, 3, 10, -11, 6);
	mushroomGradient.addColorStop(0, "rgba(107, 93, 67, 1)");
	mushroomGradient.addColorStop(1, "rgba(211, 169, 101, 1)");

	ctx.fillStyle = mushroomGradient;
	ctx.beginPath();
	ctx.arc(10, -11, 6, -0.65 * Math.PI, 0.6 * Math.PI, false);
	ctx.fill();

	ctx.restore();
}